%    This library is free software; you can redistribute it and/or
%    modify it under the terms of the GNU Lesser General Public
%    License as published by the Free Software Foundation; either
%    version 2.1 of the License, or (at your option) any later version.

%    This library is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    Lesser General Public License for more details.

%    You should have received a copy of the GNU Lesser General Public License 
%    (lgpl_license.txt) along with this library; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

function [] = write_nodefile(points,boundary,filebase)

x = points(:,1);
y = points(:,2);

num_points = length(x);

filename = strcat(filebase,'.node');
fid = fopen(filename,'w');

fprintf(fid,'%d %d %d %d\n',num_points,2,0,1);

for i=1:num_points
  fprintf(fid,'%d %4.5f %4.5f %d\n',i,x(i),y(i),boundary(i));
end

fclose(fid);
